--[[----------------------------------------------------------------------------

    ReverseGeocode is a plugin for Adobe Lightroom that fills location metadata
     based on GPS coordinates and information from OpenStreetMap Nominatim API.
    
    Copyright (C) 2019  Diego del Pozo
    
    Thanks to Michael Bungenstock for his Teekesselchen open plugin. Checking its
    code made me try to develop a new plugin   
 
--------------------------------------------------------------------------------

Updater.lua
Function to check for updates

------------------------------------------------------------------------------]]

local LrHttp = import "LrHttp"
local LrDialogs = import "LrDialogs"

local inspect = require 'inspect'

Updater = {}

function Updater.new()
	local self = {}
	self.info = {}
	
	local logger = _G.logger
	
	function self.getVersion()
		local body, headers = LrHttp.get("http://www.burgaleses.es/reversegeocode.php", nil, 5)
		local status = headers["status"]
		self.info = {}
		local version
		local isUpdate = false
		
--		logger:infof("Headers: %s",inspect(headers))
				
		if status == 200 then

--			logger:infof("Answer: %s",body)
			version = tonumber(string.match(body,"id=\"version\">(%d+%.%d+)"))
--			logger:infof("Version: --%s--",version)
--			isUpdate = version > _G.CURRENT_VERSION
--			logger:infof("Update: %s",isUpdate)
--			logger:infof("Current: %s",_G.CURRENT_VERSION)
--			logger:infof("Difference: %s",version - _G.CURRENT_VERSION)

 			return version
		end
		return false
	end

function self.getUrl()
	local result = "http://www.burgaleses.es/reversegeocode.php"
	return result
end
	
	return self
end