--[[----------------------------------------------------------------------------

    ReverseGeocode is a plugin for Adobe Lightroom that fills location metadata
     based on GPS coordinates and information from OpenStreetMap Nominatim API.
    
    Copyright (C) 2019  Diego del Pozo
    
    Thanks to Michael Bungenstock for his Teekesselchen open plugin. Checking its
    code made me try to develop a new plugin   
 
--------------------------------------------------------------------------------

PluginInit.lua

------------------------------------------------------------------------------]]

local LrPrefs = import "LrPrefs"
local LrDialogs = import "LrDialogs"
local LrTasks = import "LrTasks"
local LrHttp = import "LrHttp"
local LrLogger = import "LrLogger"

require "Configuration"
-- require "Updater"

_G.CURRENT_VERSION = 1.0
_G.myEmail = "dpozsai@hotmail.com"
_G.configuration = Configuration.new()
-- Load configuration for this plugin
local settings = _G.configuration.settings

_G.logger = LrLogger("reversegeocode")
_G.logger:enable("print")
if settings.checkForUpdates then
	LrTasks.startAsyncTask(function()
	local u = Updater.new()
	local version=u.getVersion()
	if version then
		if version > _G.CURRENT_VERSION then
			local result = LrDialogs.confirm(LOC("$$$/ReverseGeocode/UpdatesAction=A new version is available (^1)",version), LOC "$$$/ReverseGeocode/UpdatesAction2=Select Update to open download web page in browser",LOC "$$$/ReverseGeocode/Update=Update")
				if result == "ok" then
					LrHttp.openUrlInBrowser(u.getUrl())
				end
			end
		end
	end)
end


