--[[----------------------------------------------------------------------------

    ReverseGeocode is a plugin for Adobe Lightroom that fills location metadata
     based on GPS coordinates and information from OpenStreetMap Nominatim API.
    
    Copyright (C) 2019  Diego del Pozo
    
    Thanks to Michael Bungenstock for his Teekesselchen open plugin. Checking its
    code made me try to develop a new plugin   
 
--------------------------------------------------------------------------------

info.lua

Adds menu items to Lightroom.

------------------------------------------------------------------------------]]

return {
	
	LrSdkVersion = 6.0,
	-- LrSdkMinimumVersion = 3.0, -- minimum SDK version required by this plug-in (TODO)

	LrToolkitIdentifier = "es.burgaleses.lightroom.reversegeocode",

	LrPluginName = LOC "$$$/ReverseGeocode/PluginName=Reverse Geocode",
	
	LrPluginInfoUrl = "http://www.burgaleses.es/reversegeocode.php",
	
	LrInitPlugin = "PluginInit.lua",

	LrLibraryMenuItems = {{
		    title = LOC "$$$/ReverseGeocode/PluginName=Reverse Geocode",
		    file = "ReverseGeocodeDialog.lua",
		    enabledWhen = "photosSelected",
	}},
	VERSION = { major=1, minor=0, revision=0, build=1 },
}