--[[----------------------------------------------------------------------------

    ReverseGeocode is a plugin for Adobe Lightroom that fills location metadata
     based on GPS coordinates and information from OpenStreetMap Nominatim API.
    
    Copyright (C) 2019  Diego del Pozo
    
    Thanks to Michael Bungenstock for his Teekesselchen open plugin. Checking its
    code made me try to develop a new plugin   
 
--------------------------------------------------------------------------------

Configuration.lua

------------------------------------------------------------------------------]]

local LrPrefs = import "LrPrefs"
local LrLocalization = import "LrLocalization"

Configuration = {}

function Configuration.new()
	self = {}
		
	-- settings
	local defaultSettings = {
		settingISOCountry = true,
		settingCountry = true,
		settingState = true,
		settingCity = true,
		settingLocation = false,
		settingNominatimHost = "https://nominatim.openstreetmap.org/",
		settingEmail = "",
		settingNominatimTime = 1,
		settingOverwrite = false,
		settingLanguage = LrLocalization.currentLanguage(),
		activateLogging = false,
		checkForUpdates = true,
		--hidden settings
		zoomCity = 14, --best to select proper town (actually hamlets...)
		zoomLocation = 18,
		--shared variables
		processingTime = 0
	}
	

	local prefs = LrPrefs.prefsForPlugin()
	local aux = prefs.settings
	if aux == nil then aux = defaultSettings end
	
	self.settings = {}
	-- clone table
	for k,v in pairs(defaultSettings) do 
		local temp = aux[k]
		if temp == nil then
			temp = v
		end
		self.settings[k] = temp
	end
	
	
	function self.copyTo(t)
		for k,v in pairs(self.settings) do t[k] = v end
	end
	
	function self.copyFrom(t)
		for k,v in pairs(defaultSettings) do self.settings[k] = t[k] end
	end
	
	function self.write()
		prefs.settings = self.settings
	end
	
	function self.copyDefaultsTo(t)
		for k,v in pairs(defaultSettings) do t[k] = v end
	end
	
	return self
end